<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Digital Invoicing System')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <!-- Header Section -->
                    <div class="mb-8">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 text-white p-3 rounded-lg mr-4">
                                <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M4 4a2 2 0 012-2h8a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 0v12h8V4H6z"/>
                                    <path d="M8 6h4v1H8V6zm0 2h4v1H8V8zm0 2h2v1H8v-1z"/>
                                </svg>
                            </div>
                            <h1 class="text-3xl font-bold text-gray-900">Digital Invoicing</h1>
                        </div>
                        <?php if(!auth()->user()->fbr_access_token): ?>
                            <div class="bg-yellow-50 border border-yellow-200 rounded-md p-4 mb-6">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-sm font-medium text-yellow-800">
                                            FBR Access Token Required
                                        </h3>
                                        <div class="mt-2 text-sm text-yellow-700">
                                            <p>You need to set your FBR Access Token to use the invoicing system.</p>
                                        </div>
                                        <div class="mt-4">
                                            <div class="-mx-2 -my-1.5 flex">
                                                <a href="<?php echo e(route('profile.edit')); ?>" class="bg-yellow-50 px-2 py-1.5 rounded-md text-sm font-medium text-yellow-800 hover:bg-yellow-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-yellow-50 focus:ring-yellow-600">
                                                    Set Token in Profile
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Invoice Form -->
                    <form id="invoiceForm" method="POST" action="<?php echo e(route('invoicing.submit')); ?>" class="space-y-8">
                        <?php echo csrf_field(); ?>

                        <!-- Invoice Information -->
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <div class="flex items-center mb-4">
                                <svg class="w-5 h-5 text-blue-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                </svg>
                                <h2 class="text-lg font-semibold text-gray-900">Invoice Information</h2>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                                <div>
                                    <label for="invoiceType" class="block text-sm font-medium text-gray-700 mb-1">Invoice Type</label>
                                    <select id="invoiceType" name="invoiceType" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        <option value="Sale Invoice">Sale Invoice</option>
                                        <option value="Purchase Invoice">Purchase Invoice</option>
                                        <option value="Credit Note">Credit Note</option>
                                        <option value="Debit Note">Debit Note</option>
                                    </select>
                                </div>
                                <div>
                                    <label for="invoiceDate" class="block text-sm font-medium text-gray-700 mb-1">Invoice Date</label>
                                    <input type="date" id="invoiceDate" name="invoiceDate" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label for="invoiceRefNo" class="block text-sm font-medium text-gray-700 mb-1">Invoice Reference No.</label>
                                    <input type="text" id="invoiceRefNo" name="invoiceRefNo" placeholder="Enter reference number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label for="scenarioId" class="block text-sm font-medium text-gray-700 mb-1">Scenario ID</label>
                                    <input type="text" id="scenarioId" name="scenarioId" value="SN000" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                            </div>
                        </div>

                        <!-- Seller Information -->
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <div class="flex items-center mb-4">
                                <svg class="w-5 h-5 text-green-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4 4a2 2 0 00-2 2v8a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2H4zm0 2h12v8H4V6z" clip-rule="evenodd" />
                                </svg>
                                <h2 class="text-lg font-semibold text-gray-900">Seller Information</h2>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="sellerNTNCNIC" class="block text-sm font-medium text-gray-700 mb-1">CNIC/NTN</label>
                                    <input type="text" id="sellerNTNCNIC" name="sellerNTNCNIC" placeholder="0000000000000" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label for="sellerBusinessName" class="block text-sm font-medium text-gray-700 mb-1">Business Name</label>
                                    <input type="text" id="sellerBusinessName" name="sellerBusinessName" placeholder="Your Business Name" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label for="sellerProvince" class="block text-sm font-medium text-gray-700 mb-1">Province</label>
                                    <select id="sellerProvince" name="sellerProvince" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 province-select">
                                        <option value="">Select Province</option>
                                    </select>
                                </div>
                                <div class="md:col-span-2">
                                    <label for="sellerAddress" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                                    <textarea id="sellerAddress" name="sellerAddress" placeholder="Seller Address" required rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Buyer Information -->
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <div class="flex items-center mb-4">
                                <svg class="w-5 h-5 text-purple-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                                </svg>
                                <h2 class="text-lg font-semibold text-gray-900">Buyer Information</h2>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="buyerNTNCNIC" class="block text-sm font-medium text-gray-700 mb-1">NTN/CNIC</label>
                                    <input type="text" id="buyerNTNCNIC" name="buyerNTNCNIC" placeholder="0000000000000" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label for="buyerBusinessName" class="block text-sm font-medium text-gray-700 mb-1">Business Name</label>
                                    <input type="text" id="buyerBusinessName" name="buyerBusinessName" placeholder="Buyer Business Name" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label for="buyerProvince" class="block text-sm font-medium text-gray-700 mb-1">Province</label>
                                    <select id="buyerProvince" name="buyerProvince" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 province-select">
                                        <option value="">Select Province</option>
                                    </select>
                                </div>
                                <div>
                                    <label for="buyerRegistrationType" class="block text-sm font-medium text-gray-700 mb-1">
                                        Registration Type
                                        <span id="registrationTypeLoader" class="hidden ml-2">Loading...</span>
                                    </label>
                                    <input type="text" id="buyerRegistrationType" name="buyerRegistrationType" readonly class="mt-1 block w-full rounded-md border-gray-300 bg-gray-50 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="Will be determined automatically">
                                </div>
                                <div class="md:col-span-2">
                                    <label for="buyerAddress" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                                    <textarea id="buyerAddress" name="buyerAddress" placeholder="Buyer Address" required rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Items Section -->
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <div class="flex items-center justify-between mb-4">
                                <div class="flex items-center">
                                    <svg class="w-5 h-5 text-indigo-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <h2 class="text-lg font-semibold text-gray-900">Invoice Items</h2>
                                </div>
                                <button type="button" id="addItemBtn" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-500 focus:outline-none focus:border-blue-700 focus:ring focus:ring-blue-200 active:bg-blue-600 disabled:opacity-25 transition">
                                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                                    </svg>
                                    Add Item
                                </button>
                            </div>
                            <div id="itemsContainer" class="space-y-4">
                                <!-- Items will be added dynamically here -->
                            </div>
                        </div>

                        <!-- Submit Section -->
                        <div class="flex justify-end space-x-4">
                            <button type="button" id="validateBtn" class="inline-flex items-center px-6 py-3 bg-yellow-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-yellow-500 focus:outline-none focus:border-yellow-700 focus:ring focus:ring-yellow-200 active:bg-yellow-600 disabled:opacity-25 transition">
                                <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                </svg>
                                Validate Invoice
                            </button>
                            <button type="submit" id="submitBtn" class="inline-flex items-center px-6 py-3 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-500 focus:outline-none focus:border-green-700 focus:ring focus:ring-green-200 active:bg-green-600 disabled:opacity-25 transition">
                                <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-8.293l-3-3a1 1 0 00-1.414 1.414L10.586 9.5 9.293 8.207a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4a1 1 0 00-1.414-1.414L11.414 9.5z" clip-rule="evenodd" />
                                </svg>
                                Generate Invoice
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>



    <!-- Status Messages -->
    <div id="statusMessages" class="fixed top-4 right-4 z-50 space-y-2"></div>

    <script>
        // Configuration
        const API_BASE = '<?php echo e(url('/')); ?>';
        const CSRF_TOKEN = '<?php echo e(csrf_token()); ?>';
    </script>

    <script>
        // Pass data from backend to JavaScript
        window.appData = {
            provinces: <?php echo json_encode($provinces ?? [], 15, 512) ?>,
            hsCodes: <?php echo json_encode($hsCodes ?? [], 15, 512) ?>,
            uoMs: <?php echo json_encode($uoMs ?? [], 15, 512) ?>,
            transactionTypes: <?php echo json_encode($transactionTypes ?? [], 15, 512) ?>
        };
    </script>

    <script>
        // Global variables
        let itemCounter = 0;
        let provinces = window.appData.provinces;
        let hsCodes = window.appData.hsCodes;
        let uoMs = window.appData.uoMs;
        let transactionTypes = window.appData.transactionTypes;

                // Wait for dependencies to be loaded
        function waitForDependencies(callback) {
            if (window.dependenciesLoaded && typeof $ !== 'undefined' && typeof $.fn.select2 !== 'undefined') {
                callback();
            } else {
                setTimeout(() => waitForDependencies(callback), 10);
            }
        }

        // Initialize the application
        document.addEventListener('DOMContentLoaded', function() {
            waitForDependencies(function() {
                console.log('Invoicing system initializing with all dependencies loaded...');
                console.log('Initial data loaded:', {
                    provinces: provinces ? provinces.length : 0,
                    uoMs: uoMs ? uoMs.length : 0,
                    transactionTypes: transactionTypes ? transactionTypes.length : 0,
                    hsCodes: hsCodes ? hsCodes.length : 0
                });

                // Set today's date
                const today = new Date().toISOString().split('T')[0];
                document.getElementById('invoiceDate').value = today;

                            // Populate data first, then initialize Select2
            populateProvinceSelects();
            populateTransactionTypeSelects();

            // Initialize Select2 after data is populated
            initializeSelect2();

            // Load dynamic data from APIs (after initial setup)
            setTimeout(() => {
                loadAndPopulateHsCodes();
                loadAndPopulateUoM();
            }, 100);

                // Load transaction types if not already loaded
                if (!transactionTypes || transactionTypes.length === 0) {
                    loadTransactionTypesFromAPI();
                }

                // Add first item
                addItem();

                // Setup event listeners
                setupEventListeners();
            });
        });

                // Setup event listeners
        function setupEventListeners() {
            document.getElementById('addItemBtn').addEventListener('click', addItem);
            document.getElementById('validateBtn').addEventListener('click', validateInvoice);
            document.getElementById('invoiceForm').addEventListener('submit', submitInvoice);

            // Add blur event listener for buyer NTN/CNIC field
            document.getElementById('buyerNTNCNIC').addEventListener('blur', fetchRegistrationType);

            // Add event listeners for rate calculation with Select2
            $('#buyerProvince').on('select2:select', calculateRates);
            document.getElementById('invoiceDate').addEventListener('change', calculateRates);

            // Delegate event listener for sale type changes in dynamic items using Select2
            $(document).on('select2:select', '.sale-type-select', function(e) {
                calculateRatesForItem(e.target);
            });

            // Add event listener for Value Sales Excluding ST changes
            $(document).on('input', 'input[name*="[valueSalesExcludingST]"]', function(e) {
                calculateSalesTaxForItem(e.target);
            });

            // Add event listener for rate changes (when rate gets updated programmatically)
            $(document).on('input', '.rate-field', function(e) {
                calculateSalesTaxForItem(e.target);
            });
        }

        // Fetch registration type when NTN/CNIC field loses focus
        async function fetchRegistrationType() {
            const ntnCnicField = document.getElementById('buyerNTNCNIC');
            const registrationTypeField = document.getElementById('buyerRegistrationType');
            const loader = document.getElementById('registrationTypeLoader');

            const registrationNo = ntnCnicField.value.trim();

            // Reset if field is empty
            if (!registrationNo) {
                registrationTypeField.value = '';
                return;
            }

            // Basic validation for NTN/CNIC format
            if (registrationNo.length < 7) {
                registrationTypeField.value = '';
                showMessage('Please enter a valid NTN/CNIC number', 'error');
                return;
            }

            try {
                // Show loading state
                loader.classList.remove('hidden');
                registrationTypeField.value = 'Checking...';
                registrationTypeField.classList.add('bg-blue-50');

                const response = await fetch(`${API_BASE}/api/fbr/registration-type`, {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN
                    },
                    body: JSON.stringify({
                        registration_no: registrationNo
                    })
                });

                const result = await response.json();

                if (result.success && result.data) {
                    // Set the registration type
                    const registrationType = result.data.registration_type;
                    registrationTypeField.value = registrationType.charAt(0).toUpperCase() + registrationType.slice(1).toLowerCase();
                    registrationTypeField.classList.remove('bg-blue-50');
                    registrationTypeField.classList.add('bg-green-50');

                    showMessage(`Registration type updated: ${registrationTypeField.value}`, 'success');
                } else {
                    // Handle API error
                    registrationTypeField.value = 'Unregistered';
                    registrationTypeField.classList.remove('bg-blue-50');
                    registrationTypeField.classList.add('bg-yellow-50');

                    showMessage(result.message || 'Could not determine registration type. Defaulted to Unregistered.', 'warning');
                }

            } catch (error) {
                console.error('Error fetching registration type:', error);
                registrationTypeField.value = 'Unregistered';
                registrationTypeField.classList.remove('bg-blue-50');
                registrationTypeField.classList.add('bg-red-50');

                showMessage('Failed to check registration type. Defaulted to Unregistered.', 'error');
            } finally {
                // Hide loading state
                loader.classList.add('hidden');
            }
        }

        // Calculate rates for all items when global fields change
        async function calculateRates() {
            const rateFields = document.querySelectorAll('.rate-field');
            for (const rateField of rateFields) {
                await calculateRateForField(rateField);
            }
        }

        // Calculate rate for a specific item when its sale type changes
        async function calculateRatesForItem(saleTypeField) {
            const itemContainer = saleTypeField.closest('div.bg-white');
            const rateField = itemContainer.querySelector('.rate-field');
            if (rateField) {
                await calculateRateForField(rateField);
            }
        }

        // Calculate rate for a specific rate field
        async function calculateRateForField(rateField) {
            const itemContainer = rateField.closest('div.bg-white');
            const saleTypeField = itemContainer.querySelector('select[name*="[saleType]"]');
            const loader = itemContainer.querySelector('.rate-loader');

            const invoiceDate = document.getElementById('invoiceDate').value;
            const buyerProvince = $('#buyerProvince').val();
            const saleType = saleTypeField.value;

            console.log(saleType);
            console.log(invoiceDate);
            console.log(buyerProvince);
            // Reset rate field if any required field is missing
            if (!invoiceDate || !buyerProvince || !saleType) {
                rateField.value = '';
                rateField.classList.remove('bg-green-50', 'bg-red-50');
                rateField.classList.add('bg-gray-50');

                // Trigger sales tax calculation when rate is cleared
                calculateSalesTaxForItem(rateField);
                return;
            }

            // Sale type now contains only the transaction type ID
            const transTypeId = saleType;

            // Buyer province now contains the province code directly
            const provinceCode = buyerProvince;
            if (!provinceCode) {
                rateField.value = '';
                rateField.classList.remove('bg-green-50');
                rateField.classList.add('bg-red-50');
                showMessage('Invalid province selected', 'error');
                return;
            }

            try {
                // Show loading state
                if (loader) {
                    loader.classList.remove('hidden');
                }
                rateField.value = 'Loading...';
                rateField.classList.remove('bg-gray-50', 'bg-red-50');
                rateField.classList.add('bg-blue-50');

                const response = await fetch(`${API_BASE}/api/fbr/sale-type-to-rate`, {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN
                    },
                    body: JSON.stringify({
                        date: invoiceDate,
                        trans_type_id: parseInt(transTypeId),
                        origination_supplier: parseInt(provinceCode)
                    })
                });

                const result = await response.json();

                if (result.success && result.data && result.data.length > 0) {
                    // Use the first rate from the response
                    const rateData = result.data[0];
                    const rateValue = rateData.ratE_VALUE || 0;

                    rateField.value = rateValue;
                    rateField.classList.remove('bg-blue-50');
                    rateField.classList.add('bg-green-50');

                    // Show rate description as a tooltip or message
                    rateField.title = rateData.ratE_DESC || `Rate: ${rateValue}%`;

                    console.log('Rate calculated:', rateValue, '% -', rateData.ratE_DESC);

                    // Trigger sales tax calculation when rate is updated
                    calculateSalesTaxForItem(rateField);
                } else {
                    // No rate found or API error
                    rateField.value = 0;
                    rateField.classList.remove('bg-blue-50');
                    rateField.classList.add('bg-yellow-50');
                    rateField.title = 'No rate found for the selected criteria';

                    console.warn('No rate found for the given criteria');

                    // Trigger sales tax calculation when rate is updated to 0
                    calculateSalesTaxForItem(rateField);
                }

            } catch (error) {
                console.error('Error calculating rate:', error);
                rateField.value = 0;
                rateField.classList.remove('bg-blue-50');
                rateField.classList.add('bg-red-50');
                rateField.title = 'Error calculating rate';

                showMessage('Failed to calculate rate: ' + error.message, 'error');

                // Trigger sales tax calculation when rate is updated to 0 due to error
                calculateSalesTaxForItem(rateField);
            } finally {
                // Hide loading state
                if (loader) {
                    loader.classList.add('hidden');
                }
            }
        }





                                // Populate province selects with HTML options
        function populateProvinceSelects() {
            if (provinces && Array.isArray(provinces)) {
                // Update all province selects
                $('.province-select').each(function() {
                    const select = this;
                    select.innerHTML = '<option value="">Select Province</option>';

                    provinces.forEach(province => {
                        const provinceCode = province.stateProvinceCode;
                        const provinceDesc = province.stateProvinceDesc;

                        if (provinceCode && provinceDesc) {
                            const option = document.createElement('option');
                            option.value = provinceCode;
                            option.textContent = provinceDesc;
                            select.appendChild(option);
                        }
                    });
                });
                console.log('Provinces populated:', provinces.length, 'items');
            }
        }

        // Initialize Select2 for all select elements
        function initializeSelect2() {
            // Initialize Select2 for province selects
            $('.province-select').select2({
                placeholder: 'Select Province',
                allowClear: true,
                width: '100%',
                dropdownAutoWidth: true
            });

            // Initialize Select2 for other existing selects
            $('.hs-code-select').select2({
                placeholder: 'Select HS Code',
                allowClear: true,
                width: '100%',
                dropdownAutoWidth: true
            });

            $('.uom-select').select2({
                placeholder: 'Select Unit of Measure',
                allowClear: true,
                width: '100%',
                dropdownAutoWidth: true
            });

            $('.sale-type-select').select2({
                placeholder: 'Select Sale Type',
                allowClear: true,
                width: '100%',
                dropdownAutoWidth: true
            });

            console.log('Select2 initialized successfully');
        }



                                        // Populate HS code selects with HTML options
        function populateHsCodeSelects() {
            if (hsCodes && Array.isArray(hsCodes)) {
                // Update all HS code selects
                $('.hs-code-select').each(function() {
                    const select = this;
                    select.innerHTML = '<option value="">Select HS Code</option>';

                    hsCodes.forEach(item => {
                        const code = item.hS_CODE || item.code || item.hsCode || item.itemCode;
                        const description = item.description || item.itemDescription || item.desc;

                        if (code && description) {
                            const option = document.createElement('option');
                            option.value = code;
                            option.textContent = `${code} - ${description}`;
                            select.appendChild(option);
                        }
                    });
                });
                console.log('HS codes populated:', hsCodes.length, 'items');
            }
        }

                        // Load and populate HS codes from API
        async function loadAndPopulateHsCodes() {
            try {
                console.log('Loading HS codes from API...');
                const response = await fetch(`${API_BASE}/api/fbr/item-description-codes`, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN
                    }
                });

                const result = await response.json();

                if (result.success && result.data) {
                    hsCodes = result.data;
                    populateHsCodeSelects();

                    // Re-initialize Select2 for HS code selects after loading data
                    $('.hs-code-select').select2('destroy').select2({
                        placeholder: 'Select HS Code',
                        allowClear: true,
                        width: '100%',
                        dropdownAutoWidth: true
                    });

                    console.log('HS codes loaded successfully:', hsCodes.length, 'items');
                } else {
                    console.error('Failed to load HS codes:', result.message);
                    showMessage('Failed to load HS codes: ' + (result.message || 'Unknown error'), 'warning');
                }
            } catch (error) {
                console.error('Error loading HS codes:', error);
                showMessage('Error loading HS codes from server', 'error');
            }
        }

        // Load and populate UoM from API
        async function loadAndPopulateUoM() {
            try {
                console.log('Loading Units of Measurement from API...');
                const response = await fetch(`${API_BASE}/api/fbr/uom`, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN
                    }
                });

                const result = await response.json();

                if (result.success && result.data) {
                    uoMs = result.data;
                    populateUoMSelects();

                    // Re-initialize Select2 for UoM selects after loading data
                    $('.uom-select').select2('destroy').select2({
                        placeholder: 'Select Unit of Measure',
                        allowClear: true,
                        width: '100%',
                        dropdownAutoWidth: true
                    });

                    console.log('UoM loaded successfully:', uoMs.length, 'items');
                } else {
                    console.error('Failed to load UoM:', result.message);
                    showMessage('Failed to load Units of Measurement: ' + (result.message || 'Unknown error'), 'warning');
                }
            } catch (error) {
                console.error('Error loading UoM:', error);
                showMessage('Error loading Units of Measurement from server', 'error');
            }
        }



                                // Populate UoM selects with HTML options
        function populateUoMSelects() {
            if (uoMs && Array.isArray(uoMs)) {
                // Update all UoM selects
                $('.uom-select').each(function() {
                    const select = this;
                    select.innerHTML = '<option value="">Select Unit of Measure</option>';

                    uoMs.forEach(item => {
                        // Handle API response format (uoM_ID, uoM_DESC) and legacy format (id, description)
                        const uomId = item.uoM_ID || item.id;
                        const description = item.uoM_DESC || item.description;

                        if (uomId && description) {
                            const option = document.createElement('option');
                            option.value = uomId;
                            option.textContent = description;
                            select.appendChild(option);
                        }
                    });
                });
                console.log('UoMs populated:', uoMs.length, 'items');
            }
        }

                                        // Populate transaction type selects with HTML options
        function populateTransactionTypeSelects() {
            if (transactionTypes && Array.isArray(transactionTypes)) {
                // Update all transaction type selects
                $('.sale-type-select').each(function() {
                    const select = this;
                    select.innerHTML = '<option value="">Select Sale Type</option>';

                    transactionTypes.forEach(type => {
                        const typeId = type.transactioN_TYPE_ID;
                        const typeDesc = type.transactioN_DESC;

                        if (typeId && typeDesc) {
                            const option = document.createElement('option');
                            option.value = typeId;
                            option.textContent = typeDesc;
                            select.appendChild(option);
                        }
                    });
                });
                console.log('Transaction types populated:', transactionTypes.length, 'items');
            }
        }

        // Load transaction types dynamically from API
        async function loadTransactionTypesFromAPI() {
            try {
                console.log('Loading transaction types from API...');
                const response = await fetch(`${API_BASE}/api/fbr/transaction-types`, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN
                    }
                });

                const result = await response.json();

                                if (result.success && result.data) {
                    transactionTypes = result.data;
                    populateTransactionTypeSelects();

                    // Re-initialize Select2 for transaction type selects after loading data
                    $('.sale-type-select').select2('destroy').select2({
                        placeholder: 'Select Sale Type',
                        allowClear: true,
                        width: '100%',
                        dropdownAutoWidth: true
                    });

                    console.log('Transaction types loaded successfully:', transactionTypes.length, 'items');
                } else {
                    console.error('Failed to load transaction types:', result.message);
                    showMessage('Failed to load transaction types: ' + (result.message || 'Unknown error'), 'warning');
                }
            } catch (error) {
                console.error('Error loading transaction types:', error);
                showMessage('Error loading transaction types from server', 'error');
                        }
        }

        // Calculate sales tax for a specific item
        function calculateSalesTaxForItem(triggerField) {
            const itemContainer = triggerField.closest('div.bg-white');
            const rateField = itemContainer.querySelector('.rate-field');
            const valueSalesField = itemContainer.querySelector('input[name*="[valueSalesExcludingST]"]');
            const salesTaxField = itemContainer.querySelector('.sales-tax-field');

            if (!rateField || !valueSalesField || !salesTaxField) {
                console.warn('Could not find required fields for sales tax calculation');
                return;
            }

            const rate = parseFloat(rateField.value) || 0;
            const valueSales = parseFloat(valueSalesField.value) || 0;

            // Calculate: Sales Tax Applicable = (Value Sales Excluding ST * Rate) / 100
            const salesTax = (valueSales * rate) / 100;

            // Update the sales tax field
            salesTaxField.value = salesTax.toFixed(2);

            // Visual feedback
            if (rate > 0 && valueSales > 0) {
                salesTaxField.classList.remove('bg-gray-50', 'bg-red-50');
                salesTaxField.classList.add('bg-green-50');
                salesTaxField.title = `Calculated: ${valueSales} × ${rate}% = ${salesTax.toFixed(2)}`;
            } else {
                salesTaxField.classList.remove('bg-green-50');
                salesTaxField.classList.add('bg-gray-50');
                salesTaxField.title = 'Enter rate and value sales to calculate';
            }

            console.log('Sales tax calculated:', {
                rate: rate,
                valueSales: valueSales,
                salesTax: salesTax.toFixed(2)
            });
        }

        // Add new item to the form
        function addItem() {
            itemCounter++;
            const itemsContainer = document.getElementById('itemsContainer');

            const itemCard = document.createElement('div');
            itemCard.className = 'bg-white border border-gray-200 rounded-lg p-6 shadow-sm';
            itemCard.innerHTML = `
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Item ${itemCounter}</h3>
                    <button type="button" onclick="removeItem(this)" class="inline-flex items-center px-3 py-1 bg-red-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-red-500 focus:outline-none focus:border-red-700 focus:ring focus:ring-red-200 active:bg-red-600 disabled:opacity-25 transition">
                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z" clip-rule="evenodd" />
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8 7a1 1 0 012 0v4a1 1 0 11-2 0V7zm4 0a1 1 0 112 0v4a1 1 0 11-2 0V7z" clip-rule="evenodd" />
                        </svg>
                        Remove
                    </button>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Sale Type</label>
                        <select name="items[${itemCounter}][saleType]" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm sale-type-select">
                            <option value="">Select Sale Type</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">HS Code</label>
                        <select name="items[${itemCounter}][hsCode]" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm hs-code-select">
                            <option value="">Select HS Code</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Product Description</label>
                        <input type="text" name="items[${itemCounter}][productDescription]" placeholder="Enter product description" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">
                            Rate (%)
                            <span class="rate-loader hidden ml-2 text-blue-600">Loading...</span>
                        </label>
                        <input type="number" name="items[${itemCounter}][rate]" placeholder="Auto-calculated" min="0" step="0.01" required readonly class="mt-1 block w-full rounded-md border-gray-300 bg-gray-50 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm rate-field">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Unit of Measure</label>
                        <select name="items[${itemCounter}][uoM]" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm uom-select">
                            <option value="">Select Unit of Measure</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Quantity</label>
                        <input type="number" name="items[${itemCounter}][quantity]" placeholder="0" min="0" step="0.01" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Total Values</label>
                        <input type="number" name="items[${itemCounter}][totalValues]" placeholder="0" min="0" step="0.01" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Value Sales Excluding ST</label>
                        <input type="number" name="items[${itemCounter}][valueSalesExcludingST]" placeholder="0" min="0" step="0.01" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Sales Tax Applicable</label>
                        <input type="number" name="items[${itemCounter}][salesTaxApplicable]" placeholder="Auto-calculated" min="0" step="0.01" required readonly class="mt-1 block w-full rounded-md border-gray-300 bg-gray-50 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm sales-tax-field">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Fixed Notified Value/Retail Price</label>
                        <input type="number" name="items[${itemCounter}][fixedNotifiedValueOrRetailPrice]" placeholder="0" min="0" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Sales Tax Withheld at Source</label>
                        <input type="number" name="items[${itemCounter}][salesTaxWithheldAtSource]" placeholder="0" min="0" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Extra Tax</label>
                        <input type="text" name="items[${itemCounter}][extraTax]" placeholder="Enter extra tax details" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Further Tax</label>
                        <input type="number" name="items[${itemCounter}][furtherTax]" placeholder="0" min="0" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">SRO Schedule No.</label>
                        <input type="text" name="items[${itemCounter}][sroScheduleNo]" placeholder="Enter SRO schedule number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">FED Payable</label>
                        <input type="number" name="items[${itemCounter}][fedPayable]" placeholder="0" min="0" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Discount</label>
                        <input type="number" name="items[${itemCounter}][discount]" placeholder="0" min="0" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">SRO Item Serial No.</label>
                        <input type="text" name="items[${itemCounter}][sroItemSerialNo]" placeholder="Enter SRO item serial number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                    </div>
                </div>
            `;

            itemsContainer.appendChild(itemCard);

            // Populate data for the new select elements first
            const newSelects = itemCard.querySelectorAll('select');
            newSelects.forEach(select => {
                if (select.classList.contains('hs-code-select')) {
                    // Populate HS codes
                    if (hsCodes && Array.isArray(hsCodes)) {
                        select.innerHTML = '<option value="">Select HS Code</option>';
                        hsCodes.forEach(item => {
                            const code = item.hS_CODE || item.code || item.hsCode || item.itemCode;
                            const description = item.description || item.itemDescription || item.desc;

                            if (code && description) {
                                const option = document.createElement('option');
                                option.value = code;
                                option.textContent = `${code} - ${description}`;
                                select.appendChild(option);
                            }
                        });
                    }
                                } else if (select.classList.contains('uom-select')) {
                    // Populate UoMs - handle both API response format and pre-loaded format
                    if (uoMs && Array.isArray(uoMs)) {
                        select.innerHTML = '<option value="">Select Unit of Measure</option>';
                        uoMs.forEach(item => {
                            // Handle API response format (uoM_ID, uoM_DESC) and legacy format (id, description)
                            const uomId = item.uoM_ID || item.id;
                            const description = item.uoM_DESC || item.description;

                            if (uomId && description) {
                                const option = document.createElement('option');
                                option.value = uomId;
                                option.textContent = description;
                                select.appendChild(option);
                            }
                        });
                    }
                } else if (select.classList.contains('sale-type-select')) {
                    // Populate transaction types
                    if (transactionTypes && Array.isArray(transactionTypes)) {
                        select.innerHTML = '<option value="">Select Sale Type</option>';
                        transactionTypes.forEach(type => {
                            const typeId = type.transactioN_TYPE_ID;
                            const typeDesc = type.transactioN_DESC;

                            if (typeId && typeDesc) {
                                const option = document.createElement('option');
                                option.value = typeId;
                                option.textContent = typeDesc;
                                select.appendChild(option);
                            }
                        });
                    }
                }
            });

                        // Initialize Select2 after populating data
            newSelects.forEach(select => {
                const $select = $(select);
                if (select.classList.contains('hs-code-select')) {
                    $select.select2({
                        placeholder: 'Select HS Code',
                        allowClear: true,
                        width: '100%',
                        dropdownAutoWidth: true
                    });
                } else if (select.classList.contains('uom-select')) {
                    $select.select2({
                        placeholder: 'Select Unit of Measure',
                        allowClear: true,
                        width: '100%',
                        dropdownAutoWidth: true
                    });
                } else if (select.classList.contains('sale-type-select')) {
                    $select.select2({
                        placeholder: 'Select Sale Type',
                        allowClear: true,
                        width: '100%',
                        dropdownAutoWidth: true
                    });
                }
            });
        }

        // Remove item from the form
        function removeItem(button) {
            const itemCards = document.querySelectorAll('#itemsContainer > div');
            if (itemCards.length <= 1) {
                showMessage('At least one item is required!', 'error');
                return;
            }

            button.closest('div.bg-white').remove();
        }

        // Helper function to convert IDs to labels for console display
        function convertIdsToLabels(data) {
            const convertedData = JSON.parse(JSON.stringify(data)); // Deep clone

            // Convert province codes to descriptions
            if (convertedData.sellerProvince && provinces) {
                const sellerProvince = provinces.find(p => p.stateProvinceCode == convertedData.sellerProvince);
                if (sellerProvince) {
                    convertedData.sellerProvince = sellerProvince.stateProvinceDesc;
                }
            }

            if (convertedData.buyerProvince && provinces) {
                const buyerProvince = provinces.find(p => p.stateProvinceCode == convertedData.buyerProvince);
                if (buyerProvince) {
                    convertedData.buyerProvince = buyerProvince.stateProvinceDesc;
                }
            }

            // Convert item UoMs and sale types
            if (convertedData.items && Array.isArray(convertedData.items)) {
                convertedData.items.forEach(item => {
                    // Convert UoM ID to description
                    if (item.uoM && uoMs) {
                        const uom = uoMs.find(u => (u.uoM_ID || u.id) == item.uoM);
                        if (uom) {
                            item.uoM = uom.uoM_DESC || uom.description || item.uoM;
                        }
                    }

                    // Convert sale type ID to description
                    if (item.saleType && transactionTypes) {
                        const saleType = transactionTypes.find(t => t.transactioN_TYPE_ID == item.saleType);
                        if (saleType) {
                            item.saleType = saleType.transactioN_DESC || item.saleType;
                        }
                    }

                    // Ensure rate has % symbol
                    if (item.rate && !item.rate.toString().includes('%')) {
                        item.rate = item.rate + '%';
                    }
                });
            }

            return convertedData;
        }

        // Validate invoice
        async function validateInvoice() {
            const formData = new FormData(document.getElementById('invoiceForm'));
            const data = formDataToObject(formData);
            const apiUrl = `${API_BASE}/invoicing/validate`;

            // Convert IDs to labels for display
            const convertedData = convertIdsToLabels(data);

            // Console log the complete payload and API URL for debugging
            console.log('=== VALIDATE INVOICE API CALL ===');
            console.log('API URL:', apiUrl);
            console.log('Raw Form Data:', data);
            console.log('Converted Payload (what backend will send to FBR):', convertedData);
            console.log('Converted Payload JSON:', JSON.stringify(convertedData, null, 2));
            console.log('Date Value:', convertedData.invoiceDate);
            console.log('Date Format Check - Expected: YYYY-MM-DD, Current:', convertedData.invoiceDate);
            console.log('Payload Structure Check:', {
                hasSellerNTNCNIC: !!convertedData.sellerNTNCNIC,
                hasBuyerNTNCNIC: !!convertedData.buyerNTNCNIC,
                itemsCount: convertedData.items ? convertedData.items.length : 0,
                sampleItem: convertedData.items && convertedData.items[0] ? convertedData.items[0] : null
            });

            try {
                showMessage('Validating invoice...', 'info');

                const response = await fetch(apiUrl, {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN,
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });

                const result = await response.json();

                if (result.success) {
                    showMessage('Invoice validation successful!', 'success');
                } else {
                    showMessage('Validation failed: ' + result.message, 'error');
                }
            } catch (error) {
                console.error('Validation error:', error);
                showMessage('Validation failed: ' + error.message, 'error');
            }
        }

        // Submit invoice
        async function submitInvoice(e) {
            e.preventDefault();

            const formData = new FormData(e.target);
            const data = formDataToObject(formData);
            const apiUrl = `${API_BASE}/invoicing/submit`;

            // Convert IDs to labels for display
            const convertedData = convertIdsToLabels(data);

            // Console log the complete payload and API URL for debugging
            console.log('=== SUBMIT INVOICE API CALL ===');
            console.log('API URL:', apiUrl);
            console.log('Raw Form Data:', data);
            console.log('Converted Payload (what backend will send to FBR):', convertedData);
            console.log('Converted Payload JSON:', JSON.stringify(convertedData, null, 2));
            console.log('Date Value:', convertedData.invoiceDate);
            console.log('Date Format Check - Expected: YYYY-MM-DD, Current:', convertedData.invoiceDate);
            console.log('Payload Structure Check:', {
                hasSellerNTNCNIC: !!convertedData.sellerNTNCNIC,
                hasBuyerNTNCNIC: !!convertedData.buyerNTNCNIC,
                itemsCount: convertedData.items ? convertedData.items.length : 0,
                sampleItem: convertedData.items && convertedData.items[0] ? convertedData.items[0] : null
            });

            try {
                showMessage('Submitting invoice to FBR...', 'info');
                document.getElementById('submitBtn').disabled = true;

                const response = await fetch(apiUrl, {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': CSRF_TOKEN,
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });

                const result = await response.json();

                if (result.success) {
                    showMessage('Invoice submitted successfully to FBR!', 'success');
                    if (result.data && result.data.invoiceNumber) {
                        showMessage('Invoice Number: ' + result.data.invoiceNumber, 'info');
                    }

                    // Reset form
                    document.getElementById('invoiceForm').reset();
                    document.getElementById('itemsContainer').innerHTML = '';
                    itemCounter = 0;
                    addItem();

                    // Set today's date again
                    const today = new Date().toISOString().split('T')[0];
                    document.getElementById('invoiceDate').value = today;
                } else {
                    showMessage('Submission failed: ' + result.message, 'error');
                    if (result.errors) {
                        console.error('Validation errors:', result.errors);
                    }
                }
            } catch (error) {
                console.error('Submission error:', error);
                showMessage('Submission failed: ' + error.message, 'error');
            } finally {
                document.getElementById('submitBtn').disabled = false;
            }
        }

        // Convert FormData to object
        function formDataToObject(formData) {
            const obj = {};
            const items = {};

            for (let [key, value] of formData.entries()) {
                if (key.startsWith('items[')) {
                    const matches = key.match(/items\[(\d+)\]\[([^\]]+)\]/);
                    if (matches) {
                        const itemIndex = matches[1];
                        const fieldName = matches[2];

                        if (!items[itemIndex]) {
                            items[itemIndex] = {};
                        }

                        // Convert numeric fields
                        if (['rate', 'quantity', 'totalValues', 'valueSalesExcludingST', 'salesTaxApplicable',
                             'fixedNotifiedValueOrRetailPrice', 'salesTaxWithheldAtSource', 'furtherTax',
                             'fedPayable', 'discount'].includes(fieldName)) {
                            items[itemIndex][fieldName] = parseFloat(value) || 0;
                        } else {
                            items[itemIndex][fieldName] = value;
                        }
                    }
                } else {
                    obj[key] = value;
                }
            }

            obj.items = Object.values(items);
            return obj;
        }

        // Show status message
        function showMessage(message, type = 'info') {
            const messagesContainer = document.getElementById('statusMessages');
            const messageEl = document.createElement('div');

            let bgColor, textColor, iconSvg;
            switch (type) {
                case 'success':
                    bgColor = 'bg-green-50 border-green-200';
                    textColor = 'text-green-800';
                    iconSvg = '<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />';
                    break;
                case 'error':
                    bgColor = 'bg-red-50 border-red-200';
                    textColor = 'text-red-800';
                    iconSvg = '<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />';
                    break;
                case 'warning':
                    bgColor = 'bg-yellow-50 border-yellow-200';
                    textColor = 'text-yellow-800';
                    iconSvg = '<path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />';
                    break;
                default:
                    bgColor = 'bg-blue-50 border-blue-200';
                    textColor = 'text-blue-800';
                    iconSvg = '<path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />';
            }

            messageEl.className = `border rounded-md p-4 ${bgColor} shadow-lg max-w-md`;
            messageEl.innerHTML = `
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 ${textColor}" viewBox="0 0 20 20" fill="currentColor">
                            ${iconSvg}
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium ${textColor}">
                            ${message}
                        </p>
                    </div>
                    <div class="ml-auto pl-3">
                        <button onclick="this.parentElement.parentElement.remove()" class="${textColor} hover:${textColor.replace('800', '900')}">
                            <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>
                </div>
            `;

            messagesContainer.appendChild(messageEl);

            // Auto-remove after 5 seconds
            setTimeout(() => {
                if (messageEl.parentElement) {
                    messageEl.remove();
                }
            }, 5000);
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /app/resources/views/invoicing/index.blade.php ENDPATH**/ ?>