<?php

return [
    /*
    |--------------------------------------------------------------------------
    | FBR Digital Invoicing API Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration for FBR Digital Invoicing API
    | for production environment.
    |
    */

    'production_url' => env('FBR_PRODUCTION_URL', 'https://gw.fbr.gov.pk/pdi/v1/'),

    /*
    |--------------------------------------------------------------------------
    | API Endpoints
    |--------------------------------------------------------------------------
    |
    | These are the specific endpoints for different FBR API operations.
    |
    */

    'endpoints' => [
        'production' => [
            'post_invoice' => '/postinvoicedata',
            'validate_invoice' => '/validateinvoicedata',
            'provinces' => '/provinces',
            'document_types' => '/documenttypeid',
            'item_codes' => '/itemdesccode',
            'transaction_types' => '/transtypecode',
            'units_of_measurement' => '/uomcode',
            'sro_schedules' => '/sroschedule',
            'tax_rates' => '/taxrateid',
            'hs_codes_with_uom' => '/hscodewituom',
            'sro_item_ids' => '/sroitemid',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | API Timeout Settings
    |--------------------------------------------------------------------------
    |
    | Configure timeout settings for FBR API calls.
    |
    */

    'timeout' => env('FBR_API_TIMEOUT', 30),
    'connect_timeout' => env('FBR_API_CONNECT_TIMEOUT', 10),
];
